' Concerne la base de registre...
Imports Microsoft.Win32

'Pour le journal des vnements.
Imports System.Diagnostics

' Enumration pour aider  la gestion de la taille de la police.
Enum TheFontSize
    Huge = 30
    Normal = 20
    Tiny = 8
End Enum

Public Class Form1
    Inherits System.Windows.Forms.Form

    ' Contient la couleur d'arrire-plan actuelle.
    Private currColor As Color = Color.MistyRose

    ' Taille actuelle de la police.
    Private currFontSize As Integer = TheFontSize.Normal

    ' Menu principal (cr dynamiquement dans la fonction BuildMenuSystem()).
    Private mnuMain As MainMenu = New MainMenu()

    ' Le menu pop-up du formulaire.
    Private popUpMenu As ContextMenu

    ' Utilis pour garder des traces de l'lment contextuel actuellement valid.
    Private currentCheckedItem As MenuItem
    Private checkedHuge As MenuItem
    Private checkedNormal As MenuItem
    Private checkedTiny As MenuItem

    ' Pour la barre d'tat.
    Private statBar As StatusBar = New StatusBar()
    Private sbPnlPrompt As StatusBarPanel = New StatusBarPanel()
    Private sbPnlTime As StatusBarPanel = New StatusBarPanel()

    ' Timer pour la barre d'tat.
    Private WithEvents timer1 As Timer

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        ' Rcuprer les valeurs de registre pour affecter les donnes d'tat.
        Dim regKey As RegistryKey = Registry.CurrentUser
        regKey = regKey.CreateSubKey("Software\\Intertech\\Chapter9App")
        currFontSize = CInt(regKey.GetValue("CurrSize", currFontSize))
        Dim c As String = CStr(regKey.GetValue("CurrColor", currColor.Name))
        currColor = Color.FromName(c)
        BackColor = currColor

        ' Construire l'interface utilisateur originale du formulaire.
        BuildMenuSystem()
        BuildStatBar()

        ' Configurer le timer.
        timer1 = New Timer()
        timer1.Interval = 1000
        timer1.Enabled = True

        ' Configurer les proprits du formulaire.
        Text = "Formulaire final"
        CenterToScreen()
    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 273)
        Me.Name = "Form1"
        Me.Text = "Formulaire final"

    End Sub

#End Region

    ' Gestion des slections du menu contextuel.
    Private Sub PopUp_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        ' Dsactiver l'lment actuellement actif.
        currentCheckedItem.Checked = False

        ' Rcuprer la chane contenant le nom de l'lment en cours de slection.
        Dim miClicked As MenuItem = CType(sender, MenuItem)
        Dim item As String = miClicked.Text

        If (item = "Grand") Then
            currFontSize = TheFontSize.Huge
            currentCheckedItem = checkedHuge
        End If
        If (item = "Normal") Then
            currFontSize = TheFontSize.Normal
            currentCheckedItem = checkedNormal
        End If
        If (item = "Petit") Then
            currFontSize = TheFontSize.Tiny
            currentCheckedItem = checkedTiny
        End If

        ' Maintenant l'activer.
        currentCheckedItem.Checked = True
        Invalidate()
    End Sub

    ' Afficher la chane.
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Dim g As Graphics = e.Graphics
        g.DrawString("S'il vous plat cliquez sur moi...", _
             New Font("Times New Roman", currFontSize), _
             New SolidBrush(Color.Black), _
             10, 10)
    End Sub

    ' ******* Gestionnaires des slections de Menu ******* '
    Private Sub Form1_MenuComplete(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.MenuComplete
        sbPnlPrompt.Text = "Prt"
    End Sub
    Private Sub FileExit_Selected(ByVal sender As Object, ByVal e As EventArgs)
        sbPnlPrompt.Text = "Terminer cette application"
    End Sub
    Private Sub FileSave_Selected(ByVal sender As Object, ByVal e As EventArgs)
        sbPnlPrompt.Text = "Sauver les prfrences dans la base de registre"
    End Sub
    Private Sub HelpAbout_Selected(ByVal sender As Object, ByVal e As EventArgs)
        sbPnlPrompt.Text = "Afficher des infos sur l'application"
    End Sub
    ' Gestionnaire des menus Couleur | X slectionns
    Private Sub ColorMenuItem_Selected(ByVal sender As Object, ByVal e As EventArgs)
        ' Rcuprer la chane contenant le nom de l'lment en cours de slection.
        Dim miClicked As MenuItem = CType(sender, MenuItem)
        Dim item As String = miClicked.Text.Remove(0, 1)
        sbPnlPrompt.Text = "Slection de " & item
    End Sub


    ' ******* Gestionnaire de menu cliqu ******* '
    ' Gestionnaire d'vnement File | Exit cliqu.
    Private Sub FileExit_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        ' Pour l'exemple, inscrivons cet vnement
        ' dans le journal des vnements...
        Dim log As EventLog = New EventLog()
        log.Log = "Application"
        log.Source = Me.Text
        log.WriteEntry("Cette application s'est termine...")

        ' Afficher les 5 premires entres du journal Applications.
        Dim i As Integer
        For i = 0 To 4
            MessageBox.Show("Message: " & log.Entries(i).Message & vbLf & _
                 "Boite: " & log.Entries(i).MachineName & vbLf & _
                 "App: " & log.Entries(i).Source & vbLf & _
                 "Date d'entre: " & log.Entries(i).TimeWritten, _
                 "Entre du journal Applications:")
        Next
        log.Close()
        Me.Close() 'Ferme simplement l'application
    End Sub

    ' Gestionnaire d'vnement Aide | A propos.
    Private Sub HelpAbout_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        MessageBox.Show("L'tonnante application de menu...")
    End Sub

    ' Gestionnaire d'vnement Fichier | Enregistrer cliqu
    Private Sub FileSave_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        ' Enregistrer les prfrences de l'utilisateur dans la base de registre.
        Dim regKey As RegistryKey = Registry.CurrentUser
        regKey = regKey.CreateSubKey("Software\\Intertech\\Chapter9App")
        regKey.SetValue("CurrSize", currFontSize)
        regKey.SetValue("CurrColor", currColor.Name)
        MessageBox.Show("Configuration sauve dans la base de registre")
    End Sub

    ' Gestionnaire d'vnement Color | X cliqu
    Private Sub ColorItem_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        ' Rcuprer la chane contenant le nom de l'lment en cours de slection.
        Dim miClicked As MenuItem = CType(sender, MenuItem)
        Dim item As String = miClicked.Text.Remove(0, 1)

        ' Maintenant dfinir la couleur.
        BackColor = Color.FromName(item)
        currColor = BackColor
    End Sub

    ' ******* Fonctions d'aide ******* '
    Private Sub BuildStatBar()
        ' Configurer la barre d'tat.
        statBar.ShowPanels = True
        statBar.Size = New System.Drawing.Size(212, 20)
        statBar.Location = New System.Drawing.Point(0, 216)

        ' AddRange() permet d'ajouter plusieurs panneaux en mme temps.
        statBar.Panels.AddRange(New StatusBarPanel() _
            {sbPnlPrompt, sbPnlTime})

        ' Configurer le panneau d'affichage.
        sbPnlPrompt.BorderStyle = StatusBarPanelBorderStyle.None
        sbPnlPrompt.AutoSize = StatusBarPanelAutoSize.Spring
        sbPnlPrompt.Width = 62
        sbPnlPrompt.Text = "Ready"

        ' Configurer le panneau d'horloge.
        sbPnlTime.Alignment = HorizontalAlignment.Right
        sbPnlTime.Width = 76

        ' Ajouter une icne (plus de dtails dans le chapitre 9).
        Try
            ' Cette icne doit tre dans le mme rpertoire que l'application
            ' Le chapitre 9 illustrera la mthode pour intgrer
            ' des ressources dans vos assemblys.
            Dim i As Icon = New Icon("status.ico")
            sbPnlPrompt.Icon = i
        Catch e As Exception
            MessageBox.Show(e.Message)
        End Try

        ' Maintenant ajouter cette nouvelle barre d'tat  la collection de contrles du formulaire.
        Me.Controls.Add(statBar)
    End Sub

    Private Sub BuildMenuSystem()
        ' Tout d'abord crer le premier menu contextuel.
        popUpMenu = New ContextMenu()

        ' Maintenant ajouter le sous-lment et attacher le menu contextuel. 
        popUpMenu.MenuItems.Add("Grand", _
             New EventHandler(AddressOf PopUp_Clicked))
        popUpMenu.MenuItems.Add("Normal", _
             New EventHandler(AddressOf PopUp_Clicked))
        popUpMenu.MenuItems.Add("Petit", _
             New EventHandler(AddressOf PopUp_Clicked))
        Me.ContextMenu = popUpMenu

        ' Affecter chaque MenuItem au sous-menu adquat.
        checkedHuge = Me.ContextMenu.MenuItems(0)
        checkedNormal = Me.ContextMenu.MenuItems(1)
        checkedTiny = Me.ContextMenu.MenuItems(2)

        ' Valider le bon lment de menu.
        If (currFontSize = TheFontSize.Huge) Then
            currentCheckedItem = checkedHuge
        ElseIf (currFontSize = TheFontSize.Normal) Then
            currentCheckedItem = checkedNormal
        Else
            currentCheckedItem = checkedTiny
        End If

        ' Maintenant le valider.
        currentCheckedItem.Checked = True

        ' Crer le menu "Fichier" et l'ajouter  MenuItemCollection.
        Dim miFile As MenuItem = mnuMain.MenuItems.Add("&Fichier")

        ' Maintenant crer le sous-menu Fichier | Quitter et l'ajouter au menu Fichier.
        miFile.MenuItems.Add(New MenuItem("&Sauver...", _
            New EventHandler(AddressOf FileSave_Clicked), _
            Shortcut.CtrlS))
        miFile.MenuItems.Add(New MenuItem("S&ortie", _
                                New EventHandler(AddressOf FileExit_Clicked), _
                                Shortcut.CtrlX))

        ' Ajouter dynamiquement un gestionnaire pour l'vnement Select !
        AddHandler miFile.MenuItems(0).Select, AddressOf FileSave_Selected
        AddHandler miFile.MenuItems(1).Select, AddressOf FileExit_Selected

        ' Maintenant crer le menu 'Couleur'
        ' Notez que chaque sous-menu est dirig vers le 
        ' mme gestionnaire d'vnements...
        Dim miColor As MenuItem = mnuMain.MenuItems.Add("Couleur d'arrire-plan")
        miColor.MenuItems.Add("&DarkGoldenrod", New EventHandler(AddressOf ColorItem_Clicked))
        miColor.MenuItems.Add("&GreenYellow", New EventHandler(AddressOf ColorItem_Clicked))
        miColor.MenuItems.Add("&MistyRose", New EventHandler(AddressOf ColorItem_Clicked))
        miColor.MenuItems.Add("&Crimson", New EventHandler(AddressOf ColorItem_Clicked))
        miColor.MenuItems.Add("&LemonChiffon", New EventHandler(AddressOf ColorItem_Clicked))
        miColor.MenuItems.Add("&OldLace", New EventHandler(AddressOf ColorItem_Clicked))

        ' Tous les lments de menu ont le mme gestionnaire.
        Dim i As Integer
        For i = 0 To miColor.MenuItems.Count - 1
            AddHandler miColor.MenuItems(i).Select, New EventHandler(AddressOf ColorMenuItem_Selected)
        Next
        ' Maintenant crer un menu "Aide | A propos".
        Dim miHelp As MenuItem = mnuMain.MenuItems.Add("Aide")
        miHelp.MenuItems.Add(New MenuItem("&A propos", _
                New EventHandler(AddressOf HelpAbout_Clicked), _
                Shortcut.CtrlA))
        ' Ajouter dynamiquement un gestionnaire pour l'vnement Select!
        AddHandler miHelp.MenuItems(0).Select, AddressOf HelpAbout_Selected

        ' Attacher le menu principal  l'objet Form. 
        Me.Menu = mnuMain
    End Sub

    Private Sub GetTime(ByVal sender As Object, ByVal e As EventArgs) Handles timer1.Tick
        Dim t As DateTime = DateTime.Now
        Dim s As String = t.ToLongTimeString()

        ' Changer le texte du panneau pour l'heure actuelle.
        sbPnlTime.Text = s
    End Sub
End Class
